

<div class="container mt-5">
    <div class="row">
        <div class="col-md-3">
            <div class="card mb-4">
                <div class="card-header">
                    <h4>Filter Media</h4>
                </div>
                <div class="card-body">
                    <?= form_open('media', ['method' => 'get']) ?>
                        <div class="form-group">
                            <label>Category</label>
                            <select name="category" class="form-control">
                                <option value="">All Categories</option>
                                <?php foreach($categories as $category): ?>
                                    <option value="<?= $category->id ?>" 
                                        <?= $selected_category == $category->id ? 'selected' : '' ?>>
                                        <?= $category->name ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Media Type</label>
                            <select name="type" class="form-control">
                                <option value="">All Types</option>
                                <option value="image" <?= $selected_type == 'image' ? 'selected' : '' ?>>Images</option>
                                <option value="video" <?= $selected_type == 'video' ? 'selected' : '' ?>>Videos</option>
                                <option value="document" <?= $selected_type == 'document' ? 'selected' : '' ?>>Documents</option>
                            </select>
                        </div>

                        <button type="submit" class="btn btn-primary btn-block">Apply Filters</button>
                    <?= form_close() ?>
                </div>
            </div>
        </div>

        <div class="col-md-9">
            <div class="row">
                <?php if(empty($media_items)): ?>
                    <div class="col-12">
                        <div class="alert alert-info text-center">
                            No media items found.
                        </div>
                    </div>
                <?php else: ?>
                    <?php foreach($media_items as $media): ?>
                        <div class="col-md-4 mb-4">
                            <div class="card h-100">
                                <?php 
                                // Construct full path for the file
                                $file_path = base_url('uploads/media/' . $media->file_path);
                                ?>
                                <?php if($media->file_type == 'image'): ?>
                                    <img src="<?= $file_path ?>" 
                                         class="card-img-top" 
                                         alt="<?= $media->title ?>" 
                                         style="height: 200px; object-fit: cover;">
                                <?php elseif($media->file_type == 'video'): ?>
                                    <video class="card-img-top" style="height: 200px; object-fit: cover;">
                                        <source src="<?= $file_path ?>" type="video/mp4">
                                        Your browser does not support the video tag.
                                    </video>
                                <?php else: ?>
                                    <div class="card-img-top bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                                        <i class="fa fa-file fa-4x text-muted"></i>
                                    </div>
                                <?php endif; ?>

                                <div class="card-body">
                                    <h5 class="card-title"><?= $media->title ?></h5>
                                    <p class="card-text text-muted">
                                        <small>
                                            <?= $media->category_name ?> | 
                                            <?= ucfirst($media->file_type) ?>
                                        </small>
                                    </p>
                                    <a href="<?= site_url('media/view/' . $media->id) ?>" class="btn btn-primary btn-sm">
                                        View Details
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>